import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define colors for statuses
colors = {
    'empty': 'green',
    'partial': 'yellow',
    'full': 'red',
    'passenger': 'blue'
}

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Floor details
floors = [
    {'id': 'floor_0', 'y': 0, 'passengers': ['p2', 'p3'], 'elevators': {'fast': ['fast0', 'fast1'], 'slow': ['slow0-0']}},
    {'id': 'floor_1', 'y': 1, 'passengers': ['p0', 'p5'], 'elevators': {'fast': [], 'slow': []}},
    {'id': 'floor_2', 'y': 2, 'passengers': [], 'elevators': {'fast': [], 'slow': ['slow1-0']}},
    {'id': 'floor_3', 'y': 3, 'passengers': ['p1', 'p4'], 'elevators': {'fast': [], 'slow': []}},
    {'id': 'floor_4', 'y': 4, 'passengers': [], 'elevators': {'fast': [], 'slow': []}},
]

# Draw floors
floor_height = 1
floor_width = 8
for floor in floors:
    ax.add_patch(patches.Rectangle((0, floor['y']), floor_width, floor_height, edgecolor='black', facecolor='lightgrey'))
    ax.text(0.5, floor['y'] + 0.5, floor['id'], va='center', ha='center', fontsize=9, color='black')

# Draw passengers
passenger_size = 0.4
for floor in floors:
    x_offset = 0.5
    for passenger in floor['passengers']:
        ax.add_patch(patches.Rectangle((x_offset, floor['y'] + 0.3), passenger_size, passenger_size, edgecolor='black', facecolor=colors['passenger']))
        ax.text(x_offset + 0.2, floor['y'] + 0.5, passenger, va='center', ha='center', fontsize=7, color='black')
        x_offset += 0.5

# Draw elevators
elevator_size = 0.5
for floor in floors:
    x_offset_fast = 6
    x_offset_slow = 7
    for fast_elevator in floor['elevators']['fast']:
        ax.add_patch(patches.Rectangle((x_offset_fast, floor['y'] + 0.25), elevator_size, elevator_size, edgecolor='black', facecolor=colors['empty']))
        ax.text(x_offset_fast + 0.25, floor['y'] + 0.5, fast_elevator, va='center', ha='center', fontsize=7, color='black')
        x_offset_fast += 0.6
    for slow_elevator in floor['elevators']['slow']:
        ax.add_patch(patches.Rectangle((x_offset_slow, floor['y'] + 0.25), elevator_size, elevator_size, edgecolor='black', facecolor=colors['empty']))
        ax.text(x_offset_slow + 0.25, floor['y'] + 0.5, slow_elevator, va='center', ha='center', fontsize=7, color='black')
        x_offset_slow += 0.6

# Create legend
legend_elements = [
    patches.Patch(facecolor=colors['empty'], edgecolor='black', label='Elevator Empty'),
    patches.Patch(facecolor=colors['partial'], edgecolor='black', label='Elevator Partially Filled'),
    patches.Patch(facecolor=colors['full'], edgecolor='black', label='Elevator Full'),
    patches.Patch(facecolor=colors['passenger'], edgecolor='black', label='Passenger')
]
ax.legend(handles=legend_elements, loc='upper left', bbox_to_anchor=(1, 1))

# Set limits and hide axes
ax.set_xlim(-1, 9)
ax.set_ylim(-1, 6)
ax.axis('off')

# Save the figure
plt.savefig('elevator/one_shot/ini_diagram_code/attempts/attempt_8.png', bbox_inches='tight')
plt.close()